<?php
/**
 * Background Pattern Style - Pinwheel.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Pinwheel
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Pinwheel extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Pinwheel', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M52,50A48.06,48.06,0,0,1,98,2V98A48.06,48.06,0,0,1,52,50Zm-4,0A48.06,48.06,0,0,0,2,2V98A48.06,48.06,0,0,0,48,50ZM152,150a48.06,48.06,0,0,0,46,48V102A48.06,48.06,0,0,0,152,150Zm-50-48V198A48,48,0,0,0,102,102Zm48-50a48.06,48.06,0,0,0-48,46H198A48.06,48.06,0,0,0,150,52ZM198,2H102a48.06,48.06,0,0,0,48,46A48.06,48.06,0,0,0,198,2ZM50,152A48.06,48.06,0,0,0,2,198H98A48.06,48.06,0,0,0,50,152Zm0-4a48.06,48.06,0,0,0,48-46H2A48.06,48.06,0,0,0,50,148Z"/>',
				'default-inverted' => '<path d="M0,0V200H200V0ZM198,2a48.06,48.06,0,0,1-48,46A48.06,48.06,0,0,1,102,2ZM150,52a48.06,48.06,0,0,1,48,46H102A48.06,48.06,0,0,1,150,52ZM2,2A48.06,48.06,0,0,1,48,50,48.06,48.06,0,0,1,2,98ZM2,198A48,48,0,0,1,98,198Zm48-50A48.06,48.06,0,0,1,2,102H98A48.06,48.06,0,0,1,50,148ZM98,98A48,48,0,0,1,98,2Zm4,100V102A48,48,0,0,1,102,198Zm96,0A48,48,0,0,1,198,102Z"/>',
				'rotated'          => '<path d="M52,50A48.06,48.06,0,0,1,98,2V98A48.06,48.06,0,0,1,52,50Zm-4,0A48.06,48.06,0,0,0,2,2V98A48.06,48.06,0,0,0,48,50ZM152,150a48.06,48.06,0,0,0,46,48V102A48.06,48.06,0,0,0,152,150Zm-50-48V198A48,48,0,0,0,102,102Zm48-50a48.06,48.06,0,0,0-48,46H198A48.06,48.06,0,0,0,150,52ZM198,2H102a48.06,48.06,0,0,0,48,46A48.06,48.06,0,0,0,198,2ZM50,152A48.06,48.06,0,0,0,2,198H98A48.06,48.06,0,0,0,50,152Zm0-4a48.06,48.06,0,0,0,48-46H2A48.06,48.06,0,0,0,50,148Z"/>',
				'rotated-inverted' => '<path d="M0,0V200H200V0ZM198,2a48.06,48.06,0,0,1-48,46A48.06,48.06,0,0,1,102,2ZM150,52a48.06,48.06,0,0,1,48,46H102A48.06,48.06,0,0,1,150,52ZM2,2A48.06,48.06,0,0,1,48,50,48.06,48.06,0,0,1,2,98ZM2,198A48,48,0,0,1,98,198Zm48-50A48.06,48.06,0,0,1,2,102H98A48.06,48.06,0,0,1,50,148ZM98,98A48,48,0,0,1,98,2Zm4,100V102A48,48,0,0,1,102,198Zm96,0A48,48,0,0,1,198,102Z"/>',
				'thumbnail'        => '<path d="M0,0V60H80V0ZM79.59.4A9.61,9.61,0,0,1,70,9.6,9.61,9.61,0,0,1,60.41.4Zm0,20V39.59a9.6,9.6,0,0,1,0-19.18ZM70,10.4a9.61,9.61,0,0,1,9.59,9.2H60.41A9.61,9.61,0,0,1,70,10.4Zm-9.6,10a9.6,9.6,0,0,1,0,19.18Zm-.8-20V19.59A9.6,9.6,0,0,1,59.6.41ZM50,29.6a9.61,9.61,0,0,1-9.59-9.2H59.59A9.61,9.61,0,0,1,50,29.6Zm9.59,10H40.41a9.6,9.6,0,0,1,19.18,0ZM40.4.41a9.6,9.6,0,0,1,0,19.18Zm-.81,0A9.61,9.61,0,0,1,30,9.6,9.61,9.61,0,0,1,20.41.4Zm0,20V39.59a9.6,9.6,0,0,1,0-19.18ZM30,10.4a9.61,9.61,0,0,1,9.59,9.2H20.41A9.61,9.61,0,0,1,30,10.4Zm-9.6,10a9.6,9.6,0,0,1,0,19.18Zm-.8-20V19.59A9.6,9.6,0,0,1,19.6.41ZM10,29.6A9.61,9.61,0,0,1,.41,20.4H19.59A9.61,9.61,0,0,1,10,29.6Zm9.59,10H.41a9.6,9.6,0,0,1,19.18,0ZM.4.41A9.61,9.61,0,0,1,9.6,10,9.61,9.61,0,0,1,.4,19.59Zm0,59.18V40.41A9.61,9.61,0,0,1,9.6,50,9.61,9.61,0,0,1,.4,59.59Zm19.2,0a9.6,9.6,0,0,1,0-19.18Zm.81,0a9.6,9.6,0,0,1,19.18,0ZM30,49.6a9.61,9.61,0,0,1-9.59-9.2H39.59A9.61,9.61,0,0,1,30,49.6Zm10.4,10V40.41a9.6,9.6,0,0,1,0,19.18Zm19.2,0a9.6,9.6,0,0,1,0-19.18Zm.81,0a9.6,9.6,0,0,1,19.18,0ZM70,49.6a9.61,9.61,0,0,1-9.59-9.2H79.59A9.61,9.61,0,0,1,70,49.6Z"/>',
			),
			'height'     => '200px',
			'width'      => '200px',
		);
	}
}

return new ET_Builder_Pattern_Pinwheel();
